/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.event.SpectatorClientEvents;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSpectatorStatusMessage {
    private final boolean isVaultSpectating;

    public ClientboundSpectatorStatusMessage(boolean isVaultSpectating) {
        this.isVaultSpectating = isVaultSpectating;
    }

    public static void encode(ClientboundSpectatorStatusMessage msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.isVaultSpectating);
    }

    public static ClientboundSpectatorStatusMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundSpectatorStatusMessage(buffer.readBoolean());
    }

    public static void handle(ClientboundSpectatorStatusMessage msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpectatorClientEvents.setVaultSpectating(msg.isVaultSpectating)));
        ctx.setPacketHandled(true);
    }
}

