/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.init.ModGameRules;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncMaxLevelMessage {
    private final int maxLevel;

    public ClientboundSyncMaxLevelMessage(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public static void encode(ClientboundSyncMaxLevelMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.maxLevel);
    }

    public static ClientboundSyncMaxLevelMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundSyncMaxLevelMessage(buffer.readInt());
    }

    public static void handle(ClientboundSyncMaxLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundSyncMaxLevelMessage.handle(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(ClientboundSyncMaxLevelMessage message) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ((GameRules.IntegerValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.LEVEL_LOCK)).m_151489_(message.maxLevel, null);
        VaultBarOverlay.maxLevel = message.maxLevel;
    }
}

