/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModGameRules;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncVaultLockerMessage {
    private final boolean lockerEnabled;

    public ClientboundSyncVaultLockerMessage(boolean lockerEnabled) {
        this.lockerEnabled = lockerEnabled;
    }

    public static void encode(ClientboundSyncVaultLockerMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.lockerEnabled);
    }

    public static ClientboundSyncVaultLockerMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundSyncVaultLockerMessage(buffer.readBoolean());
    }

    public static void handle(ClientboundSyncVaultLockerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundSyncVaultLockerMessage.handleMessage(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(ClientboundSyncVaultLockerMessage message) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        ((GameRules.BooleanValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.LOCKER)).m_46246_(message.lockerEnabled, null);
    }
}

