/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundTESyncMessage {
    public final BlockPos pos;
    public final CompoundTag tag;

    public ClientboundTESyncMessage(BlockPos pos, CompoundTag tag) {
        this.pos = pos;
        this.tag = tag;
    }

    public static void encode(ClientboundTESyncMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130079_(message.tag);
    }

    public static ClientboundTESyncMessage decode(FriendlyByteBuf buffer) {
        return new ClientboundTESyncMessage(buffer.m_130135_(), buffer.m_130260_());
    }

    public static void handle(ClientboundTESyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundTESyncMessage.sync(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sync(ClientboundTESyncMessage message) {
        BlockEntity be;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (be = level.m_7702_(message.pos)) != null) {
            be.m_142466_(message.tag);
            be.m_6596_();
        }
    }
}

