/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.component.toast.GenericToast;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundToastMessage(String title, String message, ResourceLocation icon) {
    public static void encode(ClientboundToastMessage pkt, FriendlyByteBuf buffer) {
        buffer.m_130072_(pkt.title(), pkt.title().length());
        buffer.m_130072_(pkt.message(), pkt.message().length());
        buffer.m_130085_(pkt.icon());
    }

    public static ClientboundToastMessage decode(FriendlyByteBuf buffer) {
        String questName = buffer.m_130277_();
        String message = buffer.m_130277_();
        ResourceLocation icon = buffer.m_130281_();
        return new ClientboundToastMessage(questName, message, icon);
    }

    public static void handle(ClientboundToastMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientboundToastMessage.toast(pkt.title(), pkt.message(), pkt.icon());
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void toast(String title, String message, ResourceLocation icon) {
        GenericToast.add(title, message, icon);
    }
}

