/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.VaultAltarTileEntity;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundUpdateAltarIndexMessage(BlockPos pos, HashMap<String, Integer> displayedIndex) {
    public static void encode(ClientboundUpdateAltarIndexMessage message, FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        CompoundTag displayed = new CompoundTag();
        message.displayedIndex.forEach((arg_0, arg_1) -> ((CompoundTag)displayed).m_128405_(arg_0, arg_1));
        tag.m_128365_("Displayed", (Tag)displayed);
        buffer.m_130079_(tag);
        buffer.m_130064_(message.pos);
    }

    public static ClientboundUpdateAltarIndexMessage decode(FriendlyByteBuf buffer) {
        HashMap<String, Integer> displayedIndex = new HashMap<String, Integer>();
        CompoundTag tag = buffer.m_130260_();
        if (tag != null && tag.m_128441_("Displayed")) {
            CompoundTag displayed = tag.m_128469_("Displayed");
            for (String poolId : displayed.m_128431_()) {
                displayedIndex.put(poolId, displayed.m_128451_(poolId));
            }
        }
        BlockPos pos = buffer.m_130135_();
        return new ClientboundUpdateAltarIndexMessage(pos, displayedIndex);
    }

    public static void handle(ClientboundUpdateAltarIndexMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientboundUpdateAltarIndexMessage.updateDisplayedIndex(message, context));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateDisplayedIndex(ClientboundUpdateAltarIndexMessage message, NetworkEvent.Context context) {
        BlockPos pos = message.pos;
        HashMap<String, Integer> displayedIndex = message.displayedIndex;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VaultAltarTileEntity) {
            VaultAltarTileEntity altar = (VaultAltarTileEntity)blockEntity;
            altar.setDisplayedIndex(displayedIndex);
        }
    }
}

