/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.ModifierDiscoveryTileEntity;
import iskallia.vault.container.modifier.DiscoverableModifier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class DiscoverModifierArchiveMessage {
    private final BlockPos pos;
    private final DiscoverableModifier gearModifier;

    public DiscoverModifierArchiveMessage(BlockPos pos, DiscoverableModifier gearModifier) {
        this.pos = pos;
        this.gearModifier = gearModifier;
    }

    public static void encode(DiscoverModifierArchiveMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        message.gearModifier.serialize(buffer);
    }

    public static DiscoverModifierArchiveMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        return new DiscoverModifierArchiveMessage(pos, DiscoverableModifier.deserialize(buffer));
    }

    public static void handle(DiscoverModifierArchiveMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            BlockPos pos = message.pos;
            BlockEntity tile = player.m_183503_().m_7702_(pos);
            if (tile instanceof ModifierDiscoveryTileEntity) {
                ModifierDiscoveryTileEntity modifierDiscoveryTile = (ModifierDiscoveryTileEntity)tile;
                modifierDiscoveryTile.discoverModifierOnTile(player, message.gearModifier);
            }
        });
        context.setPacketHandled(true);
    }
}

