/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.entity.ModifierDiscoveryTileEntity;
import iskallia.vault.container.modifier.DiscoverableModifier;
import iskallia.vault.item.ModifierScrollItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class DiscoverModifierScrollMessage {
    private final UUID scrollId;
    private final int scrollSlot;
    private final DiscoverableModifier gearModifier;

    public DiscoverModifierScrollMessage(UUID scrollId, int scrollSlot, DiscoverableModifier gearModifier) {
        this.scrollId = scrollId;
        this.scrollSlot = scrollSlot;
        this.gearModifier = gearModifier;
    }

    public static void encode(DiscoverModifierScrollMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.scrollId);
        buffer.writeInt(message.scrollSlot);
        message.gearModifier.serialize(buffer);
    }

    public static DiscoverModifierScrollMessage decode(FriendlyByteBuf buffer) {
        UUID scrollId = buffer.m_130259_();
        int scrollSlot = buffer.readInt();
        return new DiscoverModifierScrollMessage(scrollId, scrollSlot, DiscoverableModifier.deserialize(buffer));
    }

    public static void handle(DiscoverModifierScrollMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack scroll = player.m_150109_().m_8020_(message.scrollSlot);
            if (scroll.m_41619_() || !(scroll.m_41720_() instanceof ModifierScrollItem)) {
                return;
            }
            UUID scrollId = ModifierScrollItem.getUuid(scroll);
            if (scrollId == null || !scrollId.equals(message.scrollId)) {
                return;
            }
            UUID playerUid = ModifierScrollItem.getPlayerUuid(scroll);
            if (playerUid != null && !playerUid.equals(player.m_142081_())) {
                return;
            }
            if (!ModifierScrollItem.getDiscoverableModifiers(scroll).contains(message.gearModifier)) {
                return;
            }
            ModifierDiscoveryTileEntity.discoverGearModifier(player, message.gearModifier);
            scroll.m_41774_(1);
            player.m_150109_().m_6836_(message.scrollSlot, scroll);
        });
        context.setPacketHandled(true);
    }
}

