/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientDiscoveredEntriesData;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DiscoveredWorkbenchModifierCraftsMessage {
    private final Map<Item, Set<ResourceLocation>> itemCrafts;

    public DiscoveredWorkbenchModifierCraftsMessage(Map<Item, Set<ResourceLocation>> itemCrafts) {
        this.itemCrafts = itemCrafts;
    }

    public static void encode(DiscoveredWorkbenchModifierCraftsMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.itemCrafts.size());
        for (Item item : message.itemCrafts.keySet()) {
            buffer.m_130085_(item.getRegistryName());
            buffer.m_178352_((Collection)message.itemCrafts.get(item), FriendlyByteBuf::m_130085_);
        }
    }

    public static DiscoveredWorkbenchModifierCraftsMessage decode(FriendlyByteBuf buffer) {
        LinkedHashMap<Item, Set<ResourceLocation>> crafts = new LinkedHashMap<Item, Set<ResourceLocation>>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
            Set keys = (Set)buffer.m_178371_(j -> new HashSet(), FriendlyByteBuf::m_130281_);
            if (item == null) continue;
            crafts.put(item, keys);
        }
        return new DiscoveredWorkbenchModifierCraftsMessage(crafts);
    }

    public static void handle(DiscoveredWorkbenchModifierCraftsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientDiscoveredEntriesData.WorkbenchCrafts.receiveMessage(message.itemCrafts));
        context.setPacketHandled(true);
    }
}

