/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import iskallia.vault.client.util.ParticleHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class EffectMessage {
    private final Type effectType;
    private final Vec3 pos;
    private FriendlyByteBuf data = null;
    private Consumer<FriendlyByteBuf> encoder = buf -> {};

    public EffectMessage(Type effectType, Vec3 pos) {
        this.effectType = effectType;
        this.pos = pos;
    }

    public Type getEffectType() {
        return this.effectType;
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public FriendlyByteBuf getData() {
        return this.data;
    }

    public EffectMessage addData(Consumer<FriendlyByteBuf> encoder) {
        this.encoder = this.encoder.andThen(encoder);
        return this;
    }

    public static void encode(EffectMessage pkt, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)pkt.effectType);
        buffer.writeDouble(pkt.pos.f_82479_);
        buffer.writeDouble(pkt.pos.f_82480_);
        buffer.writeDouble(pkt.pos.f_82481_);
        pkt.encoder.accept(buffer);
    }

    public static EffectMessage decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        EffectMessage pkt = new EffectMessage(type, new Vec3(x, y, z));
        ByteBuf buf = Unpooled.buffer((int)buffer.readableBytes());
        buffer.readBytes(buf);
        pkt.data = new FriendlyByteBuf(buf);
        return pkt;
    }

    public static void handle(EffectMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ParticleHelper.spawnParticle(pkt));
        context.setPacketHandled(true);
    }

    public static enum Type {
        COLORED_FIREWORK,
        BLOCK_BREAK_EFFECT;

    }
}

