/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ExpertiseLevelMessage {
    private final String expertiseName;
    private final boolean isUpgrade;

    public ExpertiseLevelMessage(String expertiseName, boolean isUpgrade) {
        this.expertiseName = expertiseName;
        this.isUpgrade = isUpgrade;
    }

    public static void encode(ExpertiseLevelMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.expertiseName);
        buffer.writeBoolean(message.isUpgrade);
    }

    public static ExpertiseLevelMessage decode(FriendlyByteBuf buffer) {
        return new ExpertiseLevelMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(ExpertiseLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (message.isUpgrade) {
                ExpertiseLevelMessage.upgradeExpertise(message, sender);
            }
        });
        context.setPacketHandled(true);
    }

    private static void upgradeExpertise(ExpertiseLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerExpertisesData expertisesData = PlayerExpertisesData.get(level);
        ExpertiseTree expertiseTree = expertisesData.getExpertises((Player)player);
        if (ModConfigs.SKILL_GATES.getGates().isLocked(message.expertiseName, expertiseTree)) {
            return;
        }
        expertiseTree.getForId(message.expertiseName).ifPresent(skill -> {
            LearnableSkill learnable;
            SkillContext context = SkillContext.ofExpertise(player);
            if (skill instanceof LearnableSkill && (learnable = (LearnableSkill)skill).canLearn(context)) {
                learnable.learn(context);
                PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                int learnPoints = stats.getUnspentExpertisePoints() - context.getLearnPoints();
                stats.spendExpertisePoints(player.m_20194_(), learnPoints);
                expertiseTree.sync(context);
            }
        });
    }
}

