/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.particles.FloatingAltarItemParticle;
import iskallia.vault.init.ModParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class FloatingAltarItemParticleMessage {
    private final Vec3 playerPos;
    private final int entityID;

    public FloatingAltarItemParticleMessage(Vec3 playerPos, int entityID) {
        this.playerPos = playerPos;
        this.entityID = entityID;
    }

    public static void encode(FloatingAltarItemParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeInt(message.entityID);
    }

    public static FloatingAltarItemParticleMessage decode(FriendlyByteBuf buffer) {
        return new FloatingAltarItemParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readInt());
    }

    public static void handle(FloatingAltarItemParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                FloatingAltarItemParticleMessage.spawnParticles(message.playerPos, message.entityID);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, int entityID) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        ParticleEngine pe = Minecraft.m_91087_().f_91061_;
        Entity entity = level.m_6815_(entityID);
        if (entity != null) {
            for (int i = 0; i < 20; ++i) {
                Particle particle = pe.m_107370_((ParticleOptions)ModParticles.FLOATING_ALTAR_ITEM.get(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1.0, 0.0, 0.0);
                if (!(particle instanceof FloatingAltarItemParticle)) continue;
                FloatingAltarItemParticle floatingAltarItemParticle = (FloatingAltarItemParticle)particle;
                floatingAltarItemParticle.setEntity(entity);
            }
        }
    }
}

