/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.item.JewelPouchItem;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record JewelPouchSelectionMessage(int index) {
    private static final RandomSource random = JavaRandom.ofNanoTime();

    public static void encode(JewelPouchSelectionMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.index);
    }

    public static JewelPouchSelectionMessage decode(FriendlyByteBuf buffer) {
        return new JewelPouchSelectionMessage(buffer.readInt());
    }

    public static void handle(JewelPouchSelectionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sPlayer = context.getSender();
            ItemStack stack = sPlayer.m_21120_(InteractionHand.MAIN_HAND);
            if (!(stack.m_41720_() instanceof JewelPouchItem)) {
                return;
            }
            List<JewelPouchItem.RolledJewel> outcomes = JewelPouchItem.getJewels(stack);
            if (message.index < 0 || message.index >= outcomes.size()) {
                return;
            }
            JewelPouchItem.RolledJewel outcome = outcomes.get(message.index);
            ItemStack result = outcome.stack().m_41777_();
            if (!outcome.identified()) {
                int vaultLevel = JewelPouchItem.getStoredLevel(stack).orElseGet(() -> PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel());
                result = LootInitialization.initializeVaultLoot(result, vaultLevel);
            }
            sPlayer.m_21008_(InteractionHand.MAIN_HAND, result.m_41777_());
            JewelPouchSelectionMessage.successEffects(sPlayer.f_19853_, sPlayer.m_20182_());
        });
        context.setPacketHandled(true);
    }

    public static void successEffects(Level world, Vec3 pos) {
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11688_, SoundSource.PLAYERS, 1.0f, 2.0f);
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 500, 1.0, 1.0, 1.0, 0.5);
    }
}

