/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientTalentData;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.skill.tree.TalentTree;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class KnownTalentsMessage {
    private TalentTree tree;

    public KnownTalentsMessage(TalentTree tree) {
        this.tree = tree;
    }

    public TalentTree getTree() {
        return this.tree;
    }

    public static void encode(KnownTalentsMessage message, FriendlyByteBuf buffer) {
        ArrayBitBuffer bits = ArrayBitBuffer.empty();
        message.tree.writeBits(bits);
        buffer.m_130091_(bits.toLongArray());
    }

    public static KnownTalentsMessage decode(FriendlyByteBuf buffer) {
        ArrayBitBuffer bits = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
        TalentTree tree = new TalentTree();
        tree.readBits(bits);
        return new KnownTalentsMessage(tree);
    }

    public static void handle(KnownTalentsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientTalentData.updateTalents(message));
        context.setPacketHandled(true);
    }
}

