/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.inventory.CardDeckContainer;
import iskallia.vault.container.inventory.CardDeckContainerMenu;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.item.CardDeckItem;
import java.util.function.Supplier;
import mekanism.common.integration.curios.CuriosIntegration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenCardDeckMessage {
    public static final OpenCardDeckMessage INSTANCE = new OpenCardDeckMessage();

    public static void encode(OpenCardDeckMessage pkt, FriendlyByteBuf buffer) {
    }

    public static OpenCardDeckMessage decode(FriendlyByteBuf buffer) {
        return new OpenCardDeckMessage();
    }

    public static void handle(OpenCardDeckMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (VaultUtils.isVaultLevel((Level)sender.m_183503_())) {
                sender.m_6352_((Component)new TextComponent("You can't open the card deck in a Vault!").m_130940_(ChatFormatting.RED), sender.m_142081_());
                return;
            }
            ItemStack deckStack = CuriosIntegration.getCurioStack((LivingEntity)sender, (String)"deck", (int)0);
            if (deckStack.m_41720_() instanceof CardDeckItem) {
                NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)new SimpleMenuProvider((windowId, inventory, pl) -> new CardDeckContainerMenu(windowId, inventory, 0, true, new CardDeckContainer(deckStack)), (Component)new TextComponent("Card Deck")), buf -> {
                    buf.m_130055_(deckStack);
                    buf.writeInt(0);
                    buf.writeBoolean(true);
                });
            }
        });
        context.setPacketHandled(true);
    }
}

