/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.screen.BoosterPackSelectionScreen;
import iskallia.vault.client.gui.screen.JewelPouchSelectionScreen;
import iskallia.vault.client.gui.screen.UniqueCodexScreen;
import iskallia.vault.client.gui.screen.map.FullScreenMapScreen;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.DiscoveredTunnelStat;
import iskallia.vault.core.vault.stat.StatCollector;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenClientScreenMessage {
    private final Type type;

    public OpenClientScreenMessage(Type type) {
        this.type = type;
    }

    public static void encode(OpenClientScreenMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.type);
    }

    public static OpenClientScreenMessage decode(FriendlyByteBuf buffer) {
        return new OpenClientScreenMessage((Type)buffer.m_130066_(Type.class));
    }

    public static void handle(OpenClientScreenMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> OpenClientScreenMessage.openClient(message.type));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClient(Type type) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return;
        }
        switch (type) {
            case BOOSTER_PACK: {
                Minecraft.m_91087_().m_91152_((Screen)new BoosterPackSelectionScreen(stack));
                break;
            }
            case JEWEL_POUCH: {
                Minecraft.m_91087_().m_91152_((Screen)new JewelPouchSelectionScreen(stack));
                break;
            }
            case UNIQUE_CODEX: {
                Minecraft.m_91087_().m_91152_((Screen)new UniqueCodexScreen());
                break;
            }
            case MAP_SCREEN: {
                Optional<Vault> vaultOpt = ClientVaults.getActive();
                if (!vaultOpt.isPresent()) break;
                Vault vault = vaultOpt.get();
                StatCollector statCollector = vault.get(Vault.STATS).get(player.m_142081_());
                DiscoveredRoomStat roomStat = statCollector.get(StatCollector.ROOMS_DISCOVERED);
                DiscoveredTunnelStat tunnelStat = statCollector.get(StatCollector.DISCOVERED_TUNNELS);
                Minecraft.m_91087_().f_91074_.m_6330_(SoundEvents.f_11713_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                Minecraft.m_91087_().m_91152_((Screen)new FullScreenMapScreen(vault, roomStat, tunnelStat));
            }
        }
    }

    public static enum Type {
        BOOSTER_PACK,
        JEWEL_POUCH,
        UNIQUE_CODEX,
        MAP_SCREEN;

    }
}

