/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.screen.summary.VaultEndScreen;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenVaultSnapshotMessage {

    public static class S2C {
        private final VaultSnapshot snapshot;
        private final UUID uuid;

        public S2C(VaultSnapshot snapshot, UUID uuid) {
            this.snapshot = snapshot;
            this.uuid = uuid;
        }

        public static void encode(S2C message, FriendlyByteBuf buffer) {
            ArrayBitBuffer buffer2 = ArrayBitBuffer.empty();
            message.snapshot.writeBits(buffer2);
            buffer.m_130091_(buffer2.toLongArray());
            buffer.m_130077_(message.uuid);
        }

        public static S2C decode(FriendlyByteBuf buffer) {
            ArrayBitBuffer buffer2 = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
            return new S2C(new VaultSnapshot(buffer2), buffer.m_130259_());
        }

        public static void handle(S2C message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> S2C.openEndScreen(message));
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void openEndScreen(S2C message) {
            Minecraft.m_91087_().m_91152_((Screen)new VaultEndScreen(message.snapshot, (Component)new TextComponent("Vault Exit"), message.uuid, true, true));
        }
    }
}

