/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientPatreonDisplayData;
import iskallia.vault.world.data.PlayerPatreonDisplayData;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PatreonDisplaySettingsMessage {

    public static class C2S {
        protected final PlayerPatreonDisplayData.PatreonDisplay display;

        public C2S(PlayerPatreonDisplayData.PatreonDisplay display) {
            this.display = display;
        }

        public static void encode(C2S message, FriendlyByteBuf buffer) {
            buffer.m_130079_(Objects.requireNonNullElseGet(message.display, () -> new PlayerPatreonDisplayData.PatreonDisplay(null, false, false)).serializeNBT());
        }

        public static C2S decode(FriendlyByteBuf buffer) {
            return new C2S(PlayerPatreonDisplayData.PatreonDisplay.fromNbt(buffer.m_130260_()));
        }

        public static void handle(C2S message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getSender() == null) {
                    return;
                }
                PlayerPatreonDisplayData.PatreonDisplay display = message.display;
                PlayerPatreonDisplayData.get(context.getSender().m_183503_()).setDisplaySettings(context.getSender().m_142081_(), display);
            });
            context.setPacketHandled(true);
        }
    }

    public static class S2C {
        public final PlayerPatreonDisplayData.PatreonDisplay display;

        public S2C(PlayerPatreonDisplayData.PatreonDisplay display) {
            this.display = display;
        }

        public static void encode(S2C message, FriendlyByteBuf buffer) {
            buffer.m_130079_(Objects.requireNonNullElseGet(message.display, () -> new PlayerPatreonDisplayData.PatreonDisplay(null, false, false)).serializeNBT());
        }

        public static S2C decode(FriendlyByteBuf buffer) {
            return new S2C(PlayerPatreonDisplayData.PatreonDisplay.fromNbt(buffer.m_130260_()));
        }

        public static void handle(S2C message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> ClientPatreonDisplayData.receiveData(message));
            context.setPacketHandled(true);
        }
    }
}

