/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.PersonalVaultTileEntity;
import iskallia.vault.container.PersonalVaultCraftingContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.layout.PersonalCrystalLayout;
import iskallia.vault.item.crystal.modifiers.PersonalCrystalModifiers;
import iskallia.vault.item.crystal.objective.PersonalCrystalObjective;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.network.message.ForgeParticleMessage;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.SidedHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PersonalVaultRequestCraftMessage {
    private final boolean shift;

    public PersonalVaultRequestCraftMessage(boolean shift) {
        this.shift = shift;
    }

    public static void encode(PersonalVaultRequestCraftMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.shift);
    }

    public static PersonalVaultRequestCraftMessage decode(FriendlyByteBuf buffer) {
        return new PersonalVaultRequestCraftMessage(buffer.readBoolean());
    }

    public static void handle(PersonalVaultRequestCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2131$temp;
            ServerPlayer requester = context.getSender();
            if (requester == null || !((patt2131$temp = requester.f_36096_) instanceof PersonalVaultCraftingContainer)) {
                return;
            }
            PersonalVaultCraftingContainer container = (PersonalVaultCraftingContainer)patt2131$temp;
            if (!container.getResultSlot().m_7993_().m_41619_()) {
                return;
            }
            PersonalVaultTileEntity tile = container.getTileEntity();
            if (tile == null) {
                return;
            }
            List<ItemStack> recipe = PersonalVaultCraftingContainer.getRecipe((Player)requester);
            boolean canCraft = true;
            if (!canCraft) {
                return;
            }
            Inventory playerInventory = requester.m_150109_();
            OverSizedInventory tileInventory = tile.getInventory();
            ArrayList<OverSizedItemStack> consumed = new ArrayList<OverSizedItemStack>();
            if (InventoryUtil.consumeInputs(recipe, playerInventory, tileInventory, true) && InventoryUtil.consumeInputs(recipe, playerInventory, tileInventory, false, consumed)) {
                int level = SidedHelper.getVaultLevel((Player)requester);
                ItemStack output = VaultCrystalItem.create(crystal -> {
                    crystal.setObjective(new PersonalCrystalObjective());
                    crystal.setLayout(new PersonalCrystalLayout());
                    crystal.setTheme(new ValueCrystalTheme(VaultMod.id("classic_vault_plastic")));
                    crystal.setModifiers(new PersonalCrystalModifiers());
                    crystal.setProperties(new CapacityCrystalProperties().setVolume(0).setUnmodifiable(true));
                });
                if (message.shift) {
                    if (!requester.m_150109_().m_36054_(output)) {
                        container.getResultSlot().m_5852_(output);
                    }
                } else {
                    container.getResultSlot().m_5852_(output);
                }
                requester.f_19853_.m_5594_(null, requester.m_142538_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.85f, 1.0f);
                container.m_38946_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ForgeParticleMessage(tile.m_58899_()));
            }
        });
        context.setPacketHandled(true);
    }
}

