/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PrestigePowerLevelMessage {
    private final String prestigePowerName;
    private final boolean isUpgrade;

    public PrestigePowerLevelMessage(String prestigePowerName, boolean isUpgrade) {
        this.prestigePowerName = prestigePowerName;
        this.isUpgrade = isUpgrade;
    }

    public static void encode(PrestigePowerLevelMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.prestigePowerName);
        buffer.writeBoolean(message.isUpgrade);
    }

    public static PrestigePowerLevelMessage decode(FriendlyByteBuf buffer) {
        return new PrestigePowerLevelMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(PrestigePowerLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (message.isUpgrade) {
                PrestigePowerLevelMessage.upgradePrestigePower(message, sender);
            } else {
                PrestigePowerLevelMessage.downgradePrestigePower(message, sender);
            }
        });
        context.setPacketHandled(true);
    }

    private static void upgradePrestigePower(PrestigePowerLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerPrestigePowersData prestigePowers = PlayerPrestigePowersData.get(level);
        PrestigeTree prestigeTree = prestigePowers.getPowers((Player)player);
        if (ModConfigs.SKILL_GATES.getGates().isLocked(message.prestigePowerName, prestigeTree)) {
            return;
        }
        prestigeTree.getForId(message.prestigePowerName).ifPresent(skill -> {
            TieredSkill tiered;
            LearnableSkill next;
            SkillContext context = SkillContext.ofPrestige(player);
            Skill patt2925$temp = skill.getParent();
            if (patt2925$temp instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)patt2925$temp;
                grouped.select(skill.getId());
                skill = grouped;
            }
            if (skill instanceof TieredSkill && (next = (tiered = (TieredSkill)skill).getChild(tiered.getUnmodifiedTier() + 1)) instanceof PrestigePower) {
                PrestigePower power = (PrestigePower)next;
                if (tiered.canLearn(context)) {
                    tiered.learn(context);
                    PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                    int learnPoints = stats.getUnspentPrestigePoints() - context.getLearnPoints();
                    stats.spendPrestigePoints(player.m_20194_(), learnPoints);
                    stats.spendKnowledgePoints(player.m_20194_(), power.getLearnKnowledgeCost());
                    prestigePowers.m_77762_();
                    prestigeTree.sync(context);
                }
            }
        });
    }

    private static void downgradePrestigePower(PrestigePowerLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerPrestigePowersData prestigePowers = PlayerPrestigePowersData.get(level);
        PrestigeTree prestigeTree = prestigePowers.getPowers((Player)player);
        prestigeTree.getForId(message.prestigePowerName).ifPresent(skill -> {
            LearnableSkill prev;
            TieredSkill tiered;
            int tier;
            SkillContext context = SkillContext.ofPrestige(player);
            Skill patt4395$temp = skill.getParent();
            if (patt4395$temp instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)patt4395$temp;
                grouped.select(skill.getId());
                skill = grouped;
            }
            if (skill instanceof TieredSkill && (tier = (tiered = (TieredSkill)skill).getUnmodifiedTier()) > 0 && (prev = tiered.getChild(tier)) instanceof PrestigePower) {
                PrestigePower power = (PrestigePower)prev;
                if (tiered.canRegret(context)) {
                    List<InventoryUtil.ItemAccess> items = InventoryUtil.findAllItems((Player)player);
                    boolean hasEnoughCurrency = CoinDefinition.hasEnoughCurrency(items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, prev.getRegretCost()));
                    if (!hasEnoughCurrency) {
                        return;
                    }
                    CoinDefinition.extractCurrency((Player)player, items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, prev.getRegretCost()));
                    tiered.regret(context);
                    PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                    stats.setPrestigePoints(context.getLearnPoints());
                    statsData.refundKnowledgePoints(player, power.getLearnKnowledgeCost());
                    prestigePowers.m_77762_();
                    prestigeTree.sync(context);
                }
            }
        });
    }
}

