/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.UpdateCompanionDataMessage;
import iskallia.vault.world.data.PlayerCompanionData;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class RequestCompanionDataMessage {
    private final UUID companionId;

    public RequestCompanionDataMessage(UUID companionId) {
        this.companionId = companionId;
    }

    public static void encode(RequestCompanionDataMessage message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.companionId);
    }

    public static RequestCompanionDataMessage decode(FriendlyByteBuf buffer) {
        return new RequestCompanionDataMessage(buffer.m_130259_());
    }

    public static void handle(RequestCompanionDataMessage message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            PlayerCompanionData data = PlayerCompanionData.get(player.m_20194_());
            PlayerCompanionData.CompanionData compData = data.getOrCreate(message.companionId);
            ModNetwork.CHANNEL.sendTo((Object)new UpdateCompanionDataMessage(Map.of(message.companionId, compData)), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

