/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.OpenSpectatorScreenMessage;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultPartyData;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RequestSpectatorListMessage {
    public static void encode(RequestSpectatorListMessage msg, FriendlyByteBuf buffer) {
    }

    public static RequestSpectatorListMessage decode(FriendlyByteBuf buffer) {
        return new RequestSpectatorListMessage();
    }

    public static void handle(RequestSpectatorListMessage msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            ListTag list = new ListTag();
            boolean partyOnly = player.m_183503_().m_46469_().m_46207_(ModGameRules.SPECTATOR_PARTY_ONLY);
            SpectatorMode mode = ((SpectatorMode.GameRuleValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.SPECTATOR_MODE)).get();
            VaultPartyData partyData = VaultPartyData.get(server);
            Optional<VaultPartyData.Party> playerParty = partyData.getParty(player.m_142081_());
            if (!mode.equals((Object)SpectatorMode.OFF)) {
                for (ServerLevel level : server.m_129785_()) {
                    ServerVaults.get((Level)level).ifPresent(vault -> {
                        for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                            if (!runner.isOnline()) continue;
                            UUID id = runner.get(Listener.ID);
                            ServerPlayer target = server.m_6846_().m_11259_(id);
                            if (target == null) continue;
                            if (partyOnly) {
                                Optional<VaultPartyData.Party> targetParty = partyData.getParty(id);
                                if (playerParty.isEmpty() || targetParty.isEmpty() || !((VaultPartyData.Party)playerParty.get()).equals(targetParty.get())) continue;
                            }
                            CompoundTag tag = new CompoundTag();
                            tag.m_128359_("uuid", id.toString());
                            tag.m_128359_("name", target.m_36316_().getName());
                            list.add((Object)tag);
                        }
                    });
                }
            }
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenSpectatorScreenMessage(list));
        });
        ctx.setPacketHandled(true);
    }
}

