/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class RetributionParticleMessage {
    private final Vec3 startPos;
    private final float distance;
    private final float rotation;

    public RetributionParticleMessage(Vec3 startPos, float distance, float rotation) {
        this.startPos = startPos;
        this.distance = distance;
        this.rotation = rotation;
    }

    public static void encode(RetributionParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.startPos.f_82479_);
        buffer.writeDouble(message.startPos.f_82480_);
        buffer.writeDouble(message.startPos.f_82481_);
        buffer.writeFloat(message.distance);
        buffer.writeFloat(message.rotation);
    }

    public static RetributionParticleMessage decode(FriendlyByteBuf buffer) {
        return new RetributionParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat(), buffer.readFloat());
    }

    public static void handle(RetributionParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                RetributionParticleMessage.spawnParticles(message.startPos, message.distance, message.rotation);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 startPos, float distance, float rotation) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random random = level.m_5822_();
        for (int i = 0; i < 140; ++i) {
            float rotationOffset = random.nextFloat() * 180.0f;
            float modifiedDistance = 1.0f / (Math.abs(rotationOffset - 90.0f) / 90.0f) * distance + 1.0f;
            double posX = startPos.f_82479_ + (double)(random.nextFloat() * 0.5f);
            double posY = startPos.f_82480_ + (double)(random.nextFloat() * 0.5f);
            double posZ = startPos.f_82481_ + (double)(random.nextFloat() * 0.5f);
            double perTickSpeed = modifiedDistance / 40.0f;
            perTickSpeed = perTickSpeed * 0.5 + perTickSpeed * 0.5 * random.nextDouble();
            double xSpeed = Math.cos(Math.toRadians(rotation + rotationOffset)) * perTickSpeed;
            double zSpeed = Math.sin(Math.toRadians(rotation + rotationOffset)) * perTickSpeed;
            level.m_6493_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), true, posX, posY, posZ, xSpeed, 0.0, zSpeed);
        }
    }
}

