/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.config.PersonalVaultConfig;
import iskallia.vault.container.PersonalVaultContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PersonalVaultData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPersonalVaultUnlockMessage {
    private final int slotIndex;
    private final BlockPos pos;

    public ServerBoundPersonalVaultUnlockMessage(int slotIndex, BlockPos pos) {
        this.slotIndex = slotIndex;
        this.pos = pos;
    }

    public static void encode(ServerBoundPersonalVaultUnlockMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotIndex);
        buffer.m_130064_(message.pos);
    }

    public static ServerBoundPersonalVaultUnlockMessage decode(FriendlyByteBuf buffer) {
        return new ServerBoundPersonalVaultUnlockMessage(buffer.readInt(), buffer.m_130135_());
    }

    public static void handle(ServerBoundPersonalVaultUnlockMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemStack currency;
            List<InventoryUtil.ItemAccess> allItems;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_183503_();
            int slotId = message.slotIndex;
            PersonalVaultData.Entry dataEntry = PersonalVaultData.getEntry(player.m_142081_());
            int ring = PersonalVaultData.Entry.getRing(slotId);
            if (ring <= 0) {
                return;
            }
            PersonalVaultConfig config = ModConfigs.PERSONAL_VAULT;
            PersonalVaultConfig.RingCost ringCost = config.getRingCost(ring);
            if (ringCost == null) {
                return;
            }
            int prestigePoints = ringCost.getPrestigePointCost();
            int vaultGold = ringCost.getVaultGoldCost();
            PlayerVaultStats stats = PlayerVaultStatsData.get(level).getVaultStats((Player)player);
            int playerPoints = stats.getUnspentPrestigePoints();
            boolean hasEnoughPoints = playerPoints >= prestigePoints;
            boolean hasEnoughGold = true;
            if (vaultGold > 0) {
                allItems = InventoryUtil.findAllItems((Player)player);
                currency = new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, vaultGold);
                hasEnoughGold = CoinDefinition.hasEnoughCurrency(allItems, currency);
            }
            if (hasEnoughPoints && hasEnoughGold) {
                stats.spendPrestigePoints(player.m_183503_().m_142572_(), prestigePoints);
                if (vaultGold > 0) {
                    allItems = InventoryUtil.findAllItems((Player)player);
                    currency = new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, vaultGold);
                    CoinDefinition.extractCurrency((Player)player, allItems, currency);
                }
                if (dataEntry.unlockSlot(slotId)) {
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    AbstractContainerMenu patt3742$temp = player.f_36096_;
                    if (patt3742$temp instanceof PersonalVaultContainer) {
                        PersonalVaultContainer container = (PersonalVaultContainer)patt3742$temp;
                        container.getGridInventory().m_6836_(slotId, ItemStack.f_41583_);
                        container.m_38946_();
                    }
                }
            }
        });
        context.setPacketHandled(true);
    }
}

