/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.CompanionHomeContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCompanionRelicRemoveMessage {
    private final int slotIndex;
    private final BlockPos pos;

    public ServerboundCompanionRelicRemoveMessage(int slotIndex, BlockPos pos) {
        this.slotIndex = slotIndex;
        this.pos = pos;
    }

    public static void encode(ServerboundCompanionRelicRemoveMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotIndex);
        buffer.m_130064_(message.pos);
    }

    public static ServerboundCompanionRelicRemoveMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundCompanionRelicRemoveMessage(buffer.readInt(), buffer.m_130135_());
    }

    public static void handle(ServerboundCompanionRelicRemoveMessage message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ItemStack currency;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1584$temp = player.f_36096_;
            if (!(patt1584$temp instanceof CompanionHomeContainer)) {
                return;
            }
            CompanionHomeContainer container = (CompanionHomeContainer)patt1584$temp;
            if (!container.getPos().equals((Object)message.pos)) {
                return;
            }
            if (message.slotIndex < 0 || message.slotIndex >= container.f_38839_.size()) {
                return;
            }
            Slot slot = container.m_38853_(message.slotIndex);
            if (!(slot instanceof CompanionHomeContainer.RelicSlot)) {
                return;
            }
            CompanionHomeContainer.RelicSlot relicSlot = (CompanionHomeContainer.RelicSlot)slot;
            if (!relicSlot.isUnlocked() || !slot.m_6657_()) {
                return;
            }
            int cost = ModConfigs.COMPANIONS.getRelicRemovalCost();
            List<InventoryUtil.ItemAccess> allItems = InventoryUtil.findAllItems((Player)player);
            if (!CoinDefinition.hasEnoughCurrency(allItems, currency = new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, cost))) {
                return;
            }
            CoinDefinition.extractCurrency((Player)player, allItems, currency);
            ItemStack relic = slot.m_7993_().m_41777_();
            slot.m_5852_(ItemStack.f_41583_);
            slot.m_6654_();
            container.m_38946_();
            if (!player.m_150109_().m_36054_(relic)) {
                player.m_36176_(relic, false);
            }
        });
        context.setPacketHandled(true);
    }
}

