/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.VaultMod;
import iskallia.vault.item.CompanionItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCompanionSkinChangeMessage {
    private final String newSkinName;

    public ServerboundCompanionSkinChangeMessage(String newSkinName) {
        this.newSkinName = newSkinName;
    }

    public static void encode(ServerboundCompanionSkinChangeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130072_(message.newSkinName, Short.MAX_VALUE);
    }

    public static ServerboundCompanionSkinChangeMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundCompanionSkinChangeMessage(buffer.m_130136_(Short.MAX_VALUE));
    }

    public static void handle(ServerboundCompanionSkinChangeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        VaultMod.LOGGER.info(message.newSkinName);
        context.enqueueWork(() -> {
            ItemStack companionStack;
            ServerPlayer player = context.getSender();
            if (player != null && !(companionStack = ServerboundCompanionSkinChangeMessage.findCompanionInInventory(player)).m_41619_()) {
                VaultMod.LOGGER.info(message.newSkinName);
                CompanionItem.setSkinName(companionStack, message.newSkinName);
                player.f_36095_.m_38946_();
            }
        });
        context.setPacketHandled(true);
    }

    private static ItemStack findCompanionInInventory(ServerPlayer player) {
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof CompanionItem) {
            return mainHand;
        }
        ItemStack offHand = player.m_21206_();
        if (offHand.m_41720_() instanceof CompanionItem) {
            return offHand;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof CompanionItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

