/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.container.CompanionHomeContainer;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.world.data.CompanionVariantUnlockData;
import iskallia.vault.www.Reward;
import iskallia.vault.www.RewardsManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCompanionVariantChangeMessage {
    private final String newType;
    private final BlockPos pos;

    public ServerboundCompanionVariantChangeMessage(String newType, BlockPos pos) {
        this.newType = newType;
        this.pos = pos;
    }

    public static void encode(ServerboundCompanionVariantChangeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.newType);
        buffer.m_130064_(message.pos);
    }

    public static ServerboundCompanionVariantChangeMessage decode(FriendlyByteBuf buffer) {
        String newType = buffer.m_130277_();
        BlockPos pos = buffer.m_130135_();
        return new ServerboundCompanionVariantChangeMessage(newType, pos);
    }

    public static void handle(ServerboundCompanionVariantChangeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1988$temp = player.f_36096_;
            if (!(patt1988$temp instanceof CompanionHomeContainer)) {
                return;
            }
            CompanionHomeContainer container = (CompanionHomeContainer)patt1988$temp;
            if (!container.getPos().equals((Object)message.pos)) {
                return;
            }
            if (CompanionItem.getPetSeries(container.getCompanionStack()).equals((Object)CompanionSeries.LEGEND)) {
                BlockEntity be = player.f_19853_.m_7702_(message.pos);
                if (be instanceof CompanionHomeTileEntity) {
                    CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
                    ItemStack stack = home.getCompanion();
                    CompanionItem.setPetType(stack, message.newType);
                    home.setCompanion(stack);
                    home.m_6596_();
                }
                return;
            }
            PetHelper.getVariant(message.newType).ifPresent(variant -> {
                if (variant.requiresRewards() && !RewardsManager.getInstance().getRewardData(player.m_142081_()).hasModel(Reward.ArmorPiece.COMPANION, VaultMod.id(variant.type()))) {
                    return;
                }
                if (variant.requiresUnlock() && !CompanionVariantUnlockData.get((ServerLevel)player.f_19853_).isUnlocked(player.m_142081_(), variant.type())) {
                    return;
                }
                BlockEntity be = player.f_19853_.m_7702_(message.pos);
                if (be instanceof CompanionHomeTileEntity) {
                    String companionName;
                    CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
                    ItemStack stack = home.getCompanion();
                    String previousType = CompanionItem.getPetType(stack);
                    Optional<PetHelper.PetVariant> previousVariant = PetHelper.getVariant(previousType);
                    if (previousVariant.isPresent() && ((companionName = CompanionItem.getPetName(stack)) == null || companionName.equalsIgnoreCase(previousVariant.get().displayName()))) {
                        CompanionItem.setPetName(stack, variant.displayName());
                    }
                    CompanionItem.setPetType(stack, variant.type());
                    home.setCompanion(stack);
                    home.m_6596_();
                }
            });
        });
        context.setPacketHandled(true);
    }
}

