/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CompassItem;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.world.data.VaultPlayerCompassData;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerboundCompassModeSelectMessage {
    private final VaultCompassMode mode;

    public static void send(VaultCompassMode mode) {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundCompassModeSelectMessage(mode));
    }

    public ServerboundCompassModeSelectMessage(VaultCompassMode mode) {
        this.mode = mode;
    }

    public static void encode(ServerboundCompassModeSelectMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.mode);
    }

    public static ServerboundCompassModeSelectMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundCompassModeSelectMessage((VaultCompassMode)buffer.m_130066_(VaultCompassMode.class));
    }

    public static void handle(ServerboundCompassModeSelectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VaultPlayerCompassData data;
            VaultPlayerCompassData.CompassInfo info;
            ServerPlayer player = context.getSender();
            if (player != null && (info = (data = VaultPlayerCompassData.get()).get(player.m_142081_())).isUnlocked(message.mode)) {
                VaultCompassMode previousMode = info.getMode();
                info.setMode(message.mode);
                if (VaultUtils.isVaultLevel(player.f_19853_)) {
                    ServerboundCompassModeSelectMessage.applyCompassModePenalty(player, info, previousMode, message.mode);
                }
                data.saveToPlayer(player, info);
                CompassItem.updateCompassMode(player);
                player.m_5661_((Component)new TextComponent("Compass Mode: " + message.mode.getDisplayName()), true);
            }
        });
        context.setPacketHandled(true);
    }

    private static void applyCompassModePenalty(ServerPlayer player, VaultPlayerCompassData.CompassInfo info, VaultCompassMode previousMode, VaultCompassMode newMode) {
        if (previousMode == newMode) {
            return;
        }
        if (ServerboundCompassModeSelectMessage.addCompassPenaltyModifier(player)) {
            info.incrementPenaltyStacks();
        }
    }

    public static void removeCompassModePenalty(ServerPlayer p) {
        if (p == null) {
            return;
        }
        ServerboundCompassModeSelectMessage.clearCompassPenaltyModifiers(p);
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        VaultPlayerCompassData.CompassInfo info = data.get(p.m_142081_());
        if (info.getPenaltyStacks() > 0) {
            info.resetPenaltyStacks();
            data.saveToPlayer(p, info);
        }
    }

    public static void reapplyCompassModePenalty(ServerPlayer player, VaultPlayerCompassData.CompassInfo info) {
        if (player == null || info == null) {
            return;
        }
        if (!VaultUtils.isVaultLevel(player.f_19853_)) {
            return;
        }
        int penaltyStacks = info.getPenaltyStacks();
        if (penaltyStacks <= 0) {
            return;
        }
        ServerboundCompassModeSelectMessage.clearCompassPenaltyModifiers(player);
        for (int i = 0; i < penaltyStacks; ++i) {
            ServerboundCompassModeSelectMessage.addCompassPenaltyModifier(player);
        }
    }

    public static void reapplyCompassModePenalty(ServerPlayer player) {
        if (player == null) {
            return;
        }
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        ServerboundCompassModeSelectMessage.reapplyCompassModePenalty(player, data.get(player.m_142081_()));
    }

    private static boolean addCompassPenaltyModifier(ServerPlayer player) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22276_);
        if (attr == null) {
            return false;
        }
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID(), "compass_mode_penalty", -0.1, AttributeModifier.Operation.MULTIPLY_BASE);
        attr.m_22118_(mod);
        return true;
    }

    private static void clearCompassPenaltyModifiers(ServerPlayer player) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22276_);
        if (attr == null) {
            return;
        }
        List<AttributeModifier> modifiers = attr.m_22122_().stream().filter(mod -> "compass_mode_penalty".equals(mod.m_22214_())).toList();
        modifiers.forEach(arg_0 -> ((AttributeInstance)attr).m_22130_(arg_0));
    }
}

