/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.GreedObjective;
import iskallia.vault.core.vault.objective.GreedPillarObjective;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundGreedChoiceMessage(boolean forfeit) {
    public static void encode(ServerboundGreedChoiceMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.forfeit);
    }

    public static ServerboundGreedChoiceMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundGreedChoiceMessage(buffer.readBoolean());
    }

    public static void handle(ServerboundGreedChoiceMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || VaultUtils.getVault(player.f_19853_).isEmpty()) {
                return;
            }
            ServerVaults.get(player.f_19853_).ifPresent(vault -> vault.get(Vault.OBJECTIVES).forEach(GreedObjective.class, obj -> {
                int tier = obj.get(GreedObjective.TIER);
                if (message.forfeit()) {
                    vault.get(Vault.OBJECTIVES).forEach(GreedPillarObjective.class, pillars -> {
                        if (!pillars.get(GreedPillarObjective.COMPLETED_PLAYERS).contains(player.m_142081_())) {
                            pillars.get(GreedPillarObjective.COMPLETED_PLAYERS).add(player.m_142081_());
                        }
                        return false;
                    });
                    if (tier > 0) {
                        EntityHelper.giveItem((Player)player, obj.createSeal());
                    }
                } else {
                    if (player.m_20194_() == null) {
                        return false;
                    }
                    obj.set(GreedObjective.TIER, tier + 1);
                    vault.get(Vault.CLOCK).set(TickClock.DISPLAY_TIME, 9600);
                }
                return false;
            }));
        });
        context.setPacketHandled(true);
    }
}

