/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.VaultPlayerHistoricDataMessage;
import iskallia.vault.world.data.PlayerHistoricFavoritesData;
import iskallia.vault.world.data.VaultSnapshots;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundOpenHistoricMessage {
    public static final ServerboundOpenHistoricMessage INSTANCE = new ServerboundOpenHistoricMessage();

    public static void encode(ServerboundOpenHistoricMessage message, FriendlyByteBuf buffer) {
    }

    public static ServerboundOpenHistoricMessage decode(FriendlyByteBuf buffer) {
        return INSTANCE;
    }

    public static void handle(ServerboundOpenHistoricMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ArrayList<VaultSnapshot> snapshots = new ArrayList<VaultSnapshot>(VaultSnapshots.getAll());
            List<UUID> favourites = PlayerHistoricFavoritesData.get(sender.f_8924_).getHistoricFavorites((Player)sender).getFavorites();
            Collections.reverse(snapshots);
            ArrayList<VaultSnapshot> prev50 = new ArrayList<VaultSnapshot>();
            for (VaultSnapshot snapshot : snapshots) {
                if (snapshot.getEnd() == null || !snapshot.getEnd().get(Vault.STATS).getMap().containsKey(sender.m_142081_())) continue;
                prev50.add(snapshot);
                if (prev50.size() < 50) continue;
                break;
            }
            ArrayList<VaultSnapshot> result = new ArrayList<VaultSnapshot>();
            for (VaultSnapshot snapshot : snapshots) {
                if (!favourites.stream().anyMatch(uuid -> snapshot.getEnd() != null && uuid.equals(snapshot.getEnd().get(Vault.ID))) || !prev50.stream().noneMatch(vaultSnapshot -> vaultSnapshot.getEnd() != null && vaultSnapshot.getEnd().get(Vault.ID).equals(snapshot.getEnd().get(Vault.ID)))) continue;
                result.add(snapshot);
            }
            prev50.addAll(result);
            ModNetwork.CHANNEL.sendTo((Object)new VaultPlayerHistoricDataMessage.S2C(prev50), sender.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        context.setPacketHandled(true);
    }
}

