/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.PersonalVaultCatalystContainer;
import iskallia.vault.container.PersonalVaultContainer;
import iskallia.vault.container.PersonalVaultCraftingContainer;
import iskallia.vault.init.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerboundPersonalVaultTabMessage {
    private final Action tab;
    private final BlockPos pos;

    public ServerboundPersonalVaultTabMessage(Action tab, BlockPos pos) {
        this.tab = tab;
        this.pos = pos;
    }

    public static void encode(ServerboundPersonalVaultTabMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.tab);
        buffer.m_130064_(message.pos);
    }

    public static ServerboundPersonalVaultTabMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundPersonalVaultTabMessage((Action)buffer.m_130066_(Action.class), buffer.m_130135_());
    }

    public static void handle(final ServerboundPersonalVaultTabMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    switch (message.tab) {
                        case CRAFT: {
                            return new TextComponent("Personal Vault | Crafter");
                        }
                        case CATALYST: {
                            return new TextComponent("Personal Vault | Catalysts");
                        }
                    }
                    return ModBlocks.PERSONAL_VAULT.m_49954_();
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    switch (message.tab) {
                        case CRAFT: {
                            return new PersonalVaultCraftingContainer(windowId, player, message.pos);
                        }
                        case CATALYST: {
                            return new PersonalVaultCatalystContainer(windowId, player, message.pos);
                        }
                    }
                    return new PersonalVaultContainer(windowId, player, message.pos);
                }
            }, friendlyByteBuf -> friendlyByteBuf.m_130064_(message.pos));
        });
        context.setPacketHandled(true);
    }

    public static enum Action {
        INSCRIPTION,
        CATALYST,
        CRAFT;

    }
}

