/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.tool.PaxelItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundPickaxeOffsetKeyMessage {
    private final Opcode opcode;

    private ServerboundPickaxeOffsetKeyMessage(Opcode opcode) {
        this.opcode = opcode;
    }

    public static void send(Opcode opcode) {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundPickaxeOffsetKeyMessage(opcode));
    }

    public static void encode(ServerboundPickaxeOffsetKeyMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.opcode);
    }

    public static ServerboundPickaxeOffsetKeyMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundPickaxeOffsetKeyMessage((Opcode)buffer.m_130066_(Opcode.class));
    }

    public static void handle(ServerboundPickaxeOffsetKeyMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof PaxelItem)) {
                return;
            }
            PaxelItem.addOffset(stack, new Vec2((float)message.opcode.x, (float)message.opcode.y));
            Vec2 offset = PaxelItem.getOffset(stack);
            player.m_9146_((Component)new TextComponent("Offset: x" + (int)offset.f_82470_ + ", y" + (int)offset.f_82471_), ChatType.GAME_INFO, player.m_142081_());
        });
        context.setPacketHandled(true);
    }

    public static enum Opcode {
        LEFT(-1, 0),
        RIGHT(1, 0),
        UP(0, 1),
        DOWN(0, -1);

        private final int x;
        private final int y;

        private Opcode(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

