/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.world.data.PlayerPrestigePowersData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundPrestigePowerToggleMessage {
    private final String prestigePowerId;
    private final boolean active;

    private ServerboundPrestigePowerToggleMessage(String prestigePowerId, boolean active) {
        this.prestigePowerId = prestigePowerId;
        this.active = active;
    }

    public static void send(String prestigePowerId, boolean active) {
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundPrestigePowerToggleMessage(prestigePowerId, active));
    }

    public static void encode(ServerboundPrestigePowerToggleMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.prestigePowerId);
        buffer.writeBoolean(message.active);
    }

    public static ServerboundPrestigePowerToggleMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundPrestigePowerToggleMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(ServerboundPrestigePowerToggleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            PlayerPrestigePowersData prestigePowersData = PlayerPrestigePowersData.get((ServerLevel)sender.f_19853_);
            PrestigeTree prestigeTree = prestigePowersData.getPowers((Player)sender);
            prestigeTree.getForId(message.prestigePowerId).ifPresent(skill -> {
                TieredSkill tieredSkill;
                LearnableSkill patt2315$temp;
                if (skill instanceof TieredSkill && (patt2315$temp = (tieredSkill = (TieredSkill)skill).getChild()) instanceof ActivatePrestigePower) {
                    ActivatePrestigePower activatePrestigePower = (ActivatePrestigePower)patt2315$temp;
                    if (skill.isUnlocked()) {
                        SkillContext skillContext = SkillContext.of(sender);
                        if (message.active && !activatePrestigePower.isActive()) {
                            if (activatePrestigePower.onEnable(skillContext)) {
                                activatePrestigePower.setActive(true);
                            }
                        } else if (!message.active && activatePrestigePower.isActive() && activatePrestigePower.onDisable(skillContext)) {
                            activatePrestigePower.setActive(false);
                        }
                        prestigeTree.sync(skillContext);
                        prestigePowersData.m_77762_();
                    }
                }
            });
        });
        context.setPacketHandled(true);
    }
}

