/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.VaultMod;
import iskallia.vault.block.RoyaleCrateBlock;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.InventoryUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundRoyaleSelectLootMessage {
    private final List<ItemStack> loot;

    public ServerboundRoyaleSelectLootMessage(List<ItemStack> loot) {
        this.loot = loot;
    }

    public static void encode(ServerboundRoyaleSelectLootMessage message, FriendlyByteBuf buffer) {
        buffer.m_178352_(message.loot, FriendlyByteBuf::m_130055_);
    }

    public static ServerboundRoyaleSelectLootMessage decode(FriendlyByteBuf buffer) {
        List loot = buffer.m_178366_(FriendlyByteBuf::m_130267_);
        return new ServerboundRoyaleSelectLootMessage(loot);
    }

    public static void handle(ServerboundRoyaleSelectLootMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                VaultUtils.getVault(player.f_19853_).ifPresent(vault -> {
                    if (!VaultUtils.isRoyaleVault(vault)) {
                        return;
                    }
                    RoyaleObjective objective = vault.get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).get(0);
                    if (objective == null) {
                        return;
                    }
                    int count = objective.getOr(RoyaleObjective.LOOT_MULTIPLIER, 1);
                    if (!message.loot.isEmpty() && !message.loot.get(0).m_150930_(ModItems.BOOST_MODIFICATION_STONE)) {
                        for (int i = 0; i < count; ++i) {
                            for (ItemStack item : message.loot) {
                                item.m_41784_().m_128379_("VaultRoyaleReward", true);
                                if (InventoryUtil.hasItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, iItem -> iItem.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_()))) {
                                    InventoryUtil.getFirst((NonNullList<ItemStack>)player.m_150109_().f_35974_, iItem -> iItem.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())).ifPresent(royaleCrate -> RoyaleCrateBlock.addItemToCrate(royaleCrate, OverSizedItemStack.of(item)));
                                    continue;
                                }
                                VaultMod.LOGGER.error("Failed to add item to Royale Crate: {}", (Object)item);
                            }
                        }
                    } else {
                        for (ItemStack item : message.loot) {
                            item.m_41784_().m_128379_("VaultRoyaleReward", true);
                            if (InventoryUtil.hasItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, iItem -> iItem.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_()))) {
                                InventoryUtil.getFirst((NonNullList<ItemStack>)player.m_150109_().f_35974_, iItem -> iItem.m_150930_(ModBlocks.ROYALE_CRATE_BLOCK.m_5456_())).ifPresent(royaleCrate -> RoyaleCrateBlock.addItemToCrate(royaleCrate, OverSizedItemStack.of(item)));
                                continue;
                            }
                            VaultMod.LOGGER.error("Failed to add item to Royale Crate: {}", (Object)item);
                        }
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

