/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.gear.TrinketItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundRoyaleSelectTrinketMessage {
    private final ResourceLocation trinket;
    private final int entityId;

    public ServerboundRoyaleSelectTrinketMessage(ResourceLocation trinket, Integer entityId) {
        this.trinket = trinket;
        this.entityId = entityId;
    }

    public static void encode(ServerboundRoyaleSelectTrinketMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.trinket);
        buffer.writeInt(message.entityId);
    }

    public static ServerboundRoyaleSelectTrinketMessage decode(FriendlyByteBuf buffer) {
        ResourceLocation trinket = buffer.m_130281_();
        return new ServerboundRoyaleSelectTrinketMessage(trinket, buffer.readInt());
    }

    public static void handle(ServerboundRoyaleSelectTrinketMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ItemStack stack = TrinketItem.createBaseTrinket(TrinketEffectRegistry.getEffect(message.trinket));
                TrinketItem.setUses(stack, 2);
                VaultUtils.getVault(player.f_19853_).ifPresent(vault -> TrinketItem.addUsedVault(stack, vault.get(Vault.ID)));
                TrinketItem.getSlotIdentifier(stack).ifPresent(slot -> IntegrationCurios.setCurioItemStack((LivingEntity)player, stack, slot, 0));
            }
        });
        context.setPacketHandled(true);
    }
}

