/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.config.RoyalePresetConfig;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSelectPresetMessage {
    private final String presetName;
    private final Map<String, Integer> presetData;

    public ServerboundSelectPresetMessage(String presetName, Map<String, Integer> presetData) {
        this.presetName = presetName;
        this.presetData = presetData;
    }

    public static void encode(ServerboundSelectPresetMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.presetName);
        buffer.m_178355_(message.presetData, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130130_);
    }

    public static ServerboundSelectPresetMessage decode(FriendlyByteBuf buffer) {
        String presetName = buffer.m_130277_();
        Map presetData = buffer.m_178368_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130242_);
        return new ServerboundSelectPresetMessage(presetName, presetData);
    }

    public static void handle(ServerboundSelectPresetMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                RoyalePresetConfig.apply(player, message.presetName, message.presetData);
            }
        });
        context.setPacketHandled(true);
    }
}

