/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.command.OpenVaultSnapshotCommand;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSendSnapshotLinkMessage {
    private final long timestamp;
    private final String playerName;

    public ServerboundSendSnapshotLinkMessage(long timestamp, String playerName) {
        this.timestamp = timestamp;
        this.playerName = playerName;
    }

    public static void encode(ServerboundSendSnapshotLinkMessage message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.timestamp);
        buffer.m_130070_(message.playerName);
    }

    public static ServerboundSendSnapshotLinkMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundSendSnapshotLinkMessage(buffer.readLong(), buffer.m_130136_(Short.MAX_VALUE));
    }

    public static void handle(ServerboundSendSnapshotLinkMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            OpenVaultSnapshotCommand.sendCommand(sender, message.timestamp, message.playerName, sender.f_8924_);
        });
        context.setPacketHandled(true);
    }
}

