/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.block.SkillAltarBlock;
import iskallia.vault.container.SkillAltarContainer;
import iskallia.vault.world.data.SkillAltarData;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSkillAltarActionMessage {
    private final BlockPos skillAltarPos;
    private final Action action;
    private final int templateIndex;
    private final SkillAltarData.SkillIcon icon;
    @Nullable
    private final String serializedTemplate;

    public ServerboundSkillAltarActionMessage(BlockPos skillAltarPos, Action action, int templateIndex) {
        this(skillAltarPos, action, templateIndex, null, null);
    }

    public ServerboundSkillAltarActionMessage(BlockPos skillAltarPos, Action action, int templateIndex, String serializedTemplate) {
        this(skillAltarPos, action, templateIndex, null, serializedTemplate);
    }

    public ServerboundSkillAltarActionMessage(BlockPos skillAltarPos, Action action, int templateIndex, SkillAltarData.SkillIcon icon) {
        this(skillAltarPos, action, templateIndex, icon, null);
    }

    public ServerboundSkillAltarActionMessage(BlockPos skillAltarPos, Action action, int templateIndex, SkillAltarData.SkillIcon icon, @Nullable String serializedTemplate) {
        this.skillAltarPos = skillAltarPos;
        this.action = action;
        this.templateIndex = templateIndex;
        this.icon = icon;
        this.serializedTemplate = serializedTemplate;
    }

    public static void encode(ServerboundSkillAltarActionMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.skillAltarPos);
        buffer.writeInt(message.action.ordinal());
        buffer.writeInt(message.templateIndex);
        if (message.action == Action.UPDATE_ICON) {
            message.icon.writeTo(buffer);
        }
        if (message.action == Action.IMPORT) {
            buffer.m_130070_(message.serializedTemplate);
        }
    }

    public static ServerboundSkillAltarActionMessage decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        Action action = Action.values()[buffer.readInt()];
        if (action == Action.IMPORT) {
            return new ServerboundSkillAltarActionMessage(pos, action, buffer.readInt(), buffer.m_130277_());
        }
        if (action == Action.UPDATE_ICON) {
            return new ServerboundSkillAltarActionMessage(pos, action, buffer.readInt(), SkillAltarData.SkillIcon.readFrom(buffer));
        }
        return new ServerboundSkillAltarActionMessage(pos, action, buffer.readInt());
    }

    public static void handle(ServerboundSkillAltarActionMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getSender() == null) {
            return;
        }
        context.enqueueWork(() -> {
            SkillAltarContainer container;
            AbstractContainerMenu patt2843$temp = context.getSender().f_36096_;
            if (patt2843$temp instanceof SkillAltarContainer.Default) {
                container = (SkillAltarContainer.Default)patt2843$temp;
                switch (message.action) {
                    case SAVE: {
                        ((SkillAltarContainer.Default)container).saveTemplate();
                        break;
                    }
                    case LOAD: {
                        ((SkillAltarContainer.Default)container).setPlayerAbilitiesAndTalentsFromTemplate();
                        break;
                    }
                    case UPDATE_ICON: {
                        container.updateTemplateIcon(message.icon);
                        break;
                    }
                    case SHARE: {
                        ((SkillAltarContainer.Default)container).shareInChat();
                    }
                }
            } else {
                AbstractContainerMenu patt3208$temp = context.getSender().f_36096_;
                if (patt3208$temp instanceof SkillAltarContainer.Import) {
                    SkillAltarContainer.Import container2 = (SkillAltarContainer.Import)patt3208$temp;
                    if (message.action == Action.IMPORT) {
                        container2.importTemplate(message.serializedTemplate);
                    }
                }
            }
            AbstractContainerMenu patt3399$temp = context.getSender().f_36096_;
            if (patt3399$temp instanceof SkillAltarContainer) {
                container = (SkillAltarContainer)patt3399$temp;
                if (message.action == Action.OPEN_TAB) {
                    SkillAltarBlock.openGui(message.skillAltarPos, context.getSender(), message.templateIndex, true);
                } else if (message.action == Action.OPEN_IMPORT) {
                    container.openImportScreen(message.templateIndex);
                }
            }
        });
        context.setPacketHandled(true);
    }

    public static enum Action {
        OPEN_TAB,
        SAVE,
        LOAD,
        UPDATE_ICON,
        OPEN_IMPORT,
        IMPORT,
        SHARE;

    }
}

