/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundUpdateBlacklistMessage {
    private final boolean add;
    private final ResourceLocation blacklist;

    public ServerboundUpdateBlacklistMessage(boolean add, ResourceLocation blacklist) {
        this.add = add;
        this.blacklist = blacklist;
    }

    public static void encode(ServerboundUpdateBlacklistMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.add);
        buffer.m_130085_(message.blacklist);
    }

    public static ServerboundUpdateBlacklistMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundUpdateBlacklistMessage(buffer.readBoolean(), buffer.m_130281_());
    }

    public static void handle(ServerboundUpdateBlacklistMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            if (message.add) {
                VoidStoneBlacklistData.get(serverPlayer.m_183503_()).addBlacklist(serverPlayer, message.blacklist);
            } else {
                VoidStoneBlacklistData.get(serverPlayer.m_183503_()).removeBlacklist(serverPlayer, message.blacklist);
            }
        });
    }
}

