/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.world.data.ServerVaults;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundUseCompanionTemporalMessage {
    public static final ServerboundUseCompanionTemporalMessage INSTANCE = new ServerboundUseCompanionTemporalMessage();

    public static void encode(ServerboundUseCompanionTemporalMessage pkt, FriendlyByteBuf buf) {
    }

    public static ServerboundUseCompanionTemporalMessage decode(FriendlyByteBuf buf) {
        return INSTANCE;
    }

    public static void handle(ServerboundUseCompanionTemporalMessage pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ServerVaults.get(sender.f_19853_).ifPresent(vault -> CompanionItem.getCompanion((LivingEntity)sender).ifPresent(stack -> {
                if (!CompanionItem.isOwner(stack, (Player)sender)) {
                    return;
                }
                if (CompanionItem.getCompanionHearts(stack) <= 0) {
                    return;
                }
                UUID vaultId = vault.get(Vault.ID);
                if (!VaultUtils.allowTemporal(vault) && VaultUtils.isSpecialVault(vault)) {
                    String petName = CompanionItem.getPetName(stack);
                    if (petName == null || petName.isEmpty()) {
                        petName = "Companion";
                    }
                    sender.m_6352_((Component)new TextComponent("<" + petName + "> I am too weak to modify this vault"), sender.m_142081_());
                    return;
                }
                if (CompanionItem.hasUsedTemporalIn(stack, vaultId)) {
                    return;
                }
                if (CompanionItem.isOnCooldown(stack)) {
                    return;
                }
                CompanionItem.activateTemporalModifier(sender, stack, vault);
            }));
        });
        context.setPacketHandled(true);
    }
}

