/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.gui.screen.void_stone.Tab;
import iskallia.vault.container.VoidCrucibleContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerboundVoidCrucibleTabMessage {
    private final Tab tab;
    private final BlockPos pos;

    public ServerboundVoidCrucibleTabMessage(Tab tab, BlockPos pos) {
        this.tab = tab;
        this.pos = pos;
    }

    public static void encode(ServerboundVoidCrucibleTabMessage message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.tab);
        buffer.m_130064_(message.pos);
    }

    public static ServerboundVoidCrucibleTabMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundVoidCrucibleTabMessage((Tab)buffer.m_130066_(Tab.class), buffer.m_130135_());
    }

    public static void handle(final ServerboundVoidCrucibleTabMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null) {
                return;
            }
            final VoidStoneBlacklistData.BlacklistInventory blackListInventory = VoidStoneBlacklistData.get(serverPlayer.m_183503_()).getInventory(serverPlayer);
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return ModBlocks.VOID_CRUCIBLE.m_49954_();
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    if (Objects.requireNonNull(message.tab) == Tab.THEME) {
                        return new VoidCrucibleContainer.ThemeSelect(windowId, inventory, message.pos, blackListInventory.serializeNBT());
                    }
                    return new VoidCrucibleContainer.Blacklist(windowId, inventory, message.pos, blackListInventory.getBlacklist());
                }
            }, friendlyByteBuf -> {
                friendlyByteBuf.m_130064_(message.pos);
                friendlyByteBuf.m_130079_(blackListInventory.serializeNBT());
            });
        });
        context.setPacketHandled(true);
    }
}

