/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.container.WardrobeContainer;
import iskallia.vault.init.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerboundWardrobeTabMessage {
    private final boolean openHotbar;
    private final BlockPos pos;

    public ServerboundWardrobeTabMessage(boolean openHotbar, BlockPos pos) {
        this.openHotbar = openHotbar;
        this.pos = pos;
    }

    public static void encode(ServerboundWardrobeTabMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.openHotbar);
        buffer.m_130064_(message.pos);
    }

    public static ServerboundWardrobeTabMessage decode(FriendlyByteBuf buffer) {
        return new ServerboundWardrobeTabMessage(buffer.readBoolean(), buffer.m_130135_());
    }

    public static void handle(final ServerboundWardrobeTabMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return ModBlocks.WARDROBE.m_49954_();
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    if (message.openHotbar) {
                        return new WardrobeContainer.Hotbar(windowId, inventory, message.pos);
                    }
                    return new WardrobeContainer.Gear(windowId, inventory, message.pos);
                }
            }, (BlockPos)message.pos);
        });
        context.setPacketHandled(true);
    }
}

