/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.VaultSpectatorData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class StartSpectatingPlayerMessage {
    private final UUID target;

    public StartSpectatingPlayerMessage(UUID target) {
        this.target = target;
    }

    public static void encode(StartSpectatingPlayerMessage msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.target);
    }

    public static StartSpectatingPlayerMessage decode(FriendlyByteBuf buf) {
        return new StartSpectatingPlayerMessage(buf.m_130259_());
    }

    public static void handle(StartSpectatingPlayerMessage msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                VaultSpectatorData.startSpectating(player, msg.target);
            }
        });
        ctx.setPacketHandled(true);
    }
}

