/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.entity.entity.TeamTaskScoreboardEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SummonTeamTaskScoreboardMessage {
    private final int id;
    private final UUID uuid;
    private final BlockPos pos;
    private final Direction direction;
    private final int width;
    private final int height;
    private final Vec3 position;

    public SummonTeamTaskScoreboardMessage(TeamTaskScoreboardEntity entity) {
        this.id = entity.m_142049_();
        this.uuid = entity.m_142081_();
        this.pos = entity.m_31748_();
        this.direction = entity.m_6350_();
        this.width = entity.m_7076_();
        this.height = entity.m_7068_();
        this.position = entity.m_20182_();
    }

    public SummonTeamTaskScoreboardMessage(FriendlyByteBuf buffer) {
        this.id = buffer.m_130242_();
        this.uuid = buffer.m_130259_();
        this.pos = buffer.m_130135_();
        this.direction = (Direction)buffer.m_130066_(Direction.class);
        this.width = buffer.m_130242_();
        this.height = buffer.m_130242_();
        this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void encode(SummonTeamTaskScoreboardMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.id);
        buffer.m_130077_(message.uuid);
        buffer.m_130064_(message.pos);
        buffer.m_130068_((Enum)message.direction);
        buffer.m_130130_(message.width);
        buffer.m_130130_(message.height);
        buffer.writeDouble(message.position.f_82479_);
        buffer.writeDouble(message.position.f_82480_);
        buffer.writeDouble(message.position.f_82481_);
    }

    public static SummonTeamTaskScoreboardMessage decode(FriendlyByteBuf buffer) {
        return new SummonTeamTaskScoreboardMessage(buffer);
    }

    public static void handle(SummonTeamTaskScoreboardMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SummonTeamTaskScoreboardMessage.spawnTeamTaskScoreboard(message));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnTeamTaskScoreboard(SummonTeamTaskScoreboardMessage message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        TeamTaskScoreboardEntity entity = new TeamTaskScoreboardEntity((Level)world, message.pos, message.position, message.direction, message.width, message.height);
        entity.m_20167_(message.pos.m_123341_(), message.pos.m_123342_(), message.pos.m_123343_());
        entity.m_20234_(message.id);
        entity.m_20084_(message.uuid);
        world.m_104627_(message.id, (Entity)entity);
    }
}

