/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.client.ClientGreedData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncGreedDataMessage {
    protected final boolean completedArtifacts;
    protected final boolean completedHerald;
    protected final int greedTier;

    public SyncGreedDataMessage(boolean completedArtifacts, boolean completedHerald, int greedTier) {
        this.completedArtifacts = completedArtifacts;
        this.completedHerald = completedHerald;
        this.greedTier = greedTier;
    }

    public static void encode(SyncGreedDataMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.completedArtifacts);
        buffer.writeBoolean(message.completedHerald);
        buffer.writeInt(message.greedTier);
    }

    public static SyncGreedDataMessage decode(FriendlyByteBuf buffer) {
        return new SyncGreedDataMessage(buffer.readBoolean(), buffer.readBoolean(), buffer.readInt());
    }

    public static void handle(SyncGreedDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientGreedData.receiveUpdate(message.completedArtifacts, message.completedHerald, message.greedTier));
        context.setPacketHandled(true);
    }
}

