/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class TalentLevelMessage {
    private final String talentName;
    private final boolean isUpgrade;

    public TalentLevelMessage(String talentName, boolean isUpgrade) {
        this.talentName = talentName;
        this.isUpgrade = isUpgrade;
    }

    public static void encode(TalentLevelMessage message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.talentName);
        buffer.writeBoolean(message.isUpgrade);
    }

    public static TalentLevelMessage decode(FriendlyByteBuf buffer) {
        return new TalentLevelMessage(buffer.m_130277_(), buffer.readBoolean());
    }

    public static void handle(TalentLevelMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (message.isUpgrade) {
                TalentLevelMessage.upgradeTalent(message, sender);
            } else {
                TalentLevelMessage.downgradeTalent(message, sender);
            }
        });
        context.setPacketHandled(true);
    }

    private static void upgradeTalent(TalentLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerTalentsData abilitiesData = PlayerTalentsData.get(level);
        TalentTree talentTree = abilitiesData.getTalents((Player)player);
        if (ModConfigs.SKILL_GATES.getGates().isLocked(message.talentName, talentTree)) {
            return;
        }
        talentTree.getForId(message.talentName).ifPresent(skill -> {
            LearnableSkill learnable;
            SkillContext context = SkillContext.of(player);
            Skill patt2662$temp = skill.getParent();
            if (patt2662$temp instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)patt2662$temp;
                grouped.select(skill.getId());
                skill = grouped;
            }
            if (skill instanceof LearnableSkill && (learnable = (LearnableSkill)skill).canLearn(context)) {
                learnable.learn(context);
                PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                stats.setSkillPoints(context.getLearnPoints());
                talentTree.sync(context);
            }
        });
    }

    private static void downgradeTalent(TalentLevelMessage message, ServerPlayer player) {
        ServerLevel level = player.m_183503_();
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(level);
        PlayerTalentsData talentsData = PlayerTalentsData.get(level);
        TalentTree talentTree = talentsData.getTalents((Player)player);
        talentTree.getForId(message.talentName).ifPresent(skill -> {
            LearnableSkill learnable;
            SkillContext context = SkillContext.of(player);
            Skill patt3649$temp = skill.getParent();
            if (patt3649$temp instanceof GroupedSkill) {
                GroupedSkill grouped = (GroupedSkill)patt3649$temp;
                grouped.select(skill.getId());
                skill = grouped;
            }
            if (skill instanceof LearnableSkill && (learnable = (LearnableSkill)skill).canRegret(context)) {
                List<InventoryUtil.ItemAccess> items = InventoryUtil.findAllItems((Player)player);
                boolean hasEnoughCurrency = CoinDefinition.hasEnoughCurrency(items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, learnable.getRegretCost()));
                if (!hasEnoughCurrency) {
                    return;
                }
                CoinDefinition.extractCurrency((Player)player, items, new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, learnable.getRegretCost()));
                learnable.regret(context);
                PlayerVaultStats stats = statsData.getVaultStats((Player)player);
                stats.setSkillPoints(context.getLearnPoints());
                talentTree.sync(context);
            }
        });
    }
}

