/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class TauntParticleMessage {
    private final Vec3 playerPos;
    private final float radius;

    public TauntParticleMessage(Vec3 playerPos, float radius) {
        this.playerPos = playerPos;
        this.radius = radius;
    }

    public static void encode(TauntParticleMessage message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.playerPos.f_82479_);
        buffer.writeDouble(message.playerPos.f_82480_);
        buffer.writeDouble(message.playerPos.f_82481_);
        buffer.writeFloat(message.radius);
    }

    public static TauntParticleMessage decode(FriendlyByteBuf buffer) {
        return new TauntParticleMessage(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat());
    }

    public static void handle(TauntParticleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                TauntParticleMessage.spawnParticles(message.playerPos, message.radius);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(Vec3 pos, float radius) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        float usedRadius = level.f_46441_.nextFloat() * radius;
        float rotation = level.f_46441_.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(Math.cos(rotation) * (double)usedRadius, 0.0, Math.sin(rotation) * (double)usedRadius);
        level.m_6493_((ParticleOptions)ParticleTypes.f_123792_, true, pos.m_7096_() + offset.f_82479_, pos.m_7098_() + offset.f_82480_, pos.m_7094_() + offset.f_82481_, 0.0, 0.0, 0.0);
    }
}

