/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.tool.ToolItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ToolMessage {
    public static void sendOffset(int key) {
        ModNetwork.CHANNEL.sendToServer((Object)new Offset(key));
    }

    public static class Offset {
        public static final int RIGHT = 262;
        public static final int LEFT = 263;
        public static final int DOWN = 264;
        public static final int UP = 265;
        private int key;

        public Offset(int key) {
            this.key = key;
        }

        public static boolean isKey(int key) {
            return key >= 262 && key <= 265;
        }

        public static void encode(Offset message, FriendlyByteBuf buffer) {
            buffer.m_130130_(message.key);
        }

        public static Offset decode(FriendlyByteBuf buffer) {
            return new Offset(buffer.m_130242_());
        }

        public static void handle(Offset message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = player.m_21205_();
                if (stack.m_41720_() != ModItems.TOOL) {
                    return;
                }
                switch (message.key) {
                    case 262: {
                        ToolItem.offset(stack, 1, 0);
                        break;
                    }
                    case 263: {
                        ToolItem.offset(stack, -1, 0);
                        break;
                    }
                    case 264: {
                        ToolItem.offset(stack, 0, -1);
                        break;
                    }
                    case 265: {
                        ToolItem.offset(stack, 0, 1);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

