/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class TrappedMobChestParticlesMessage {
    private final BlockPos chestPos;

    public TrappedMobChestParticlesMessage(BlockPos chestPos) {
        this.chestPos = chestPos;
    }

    public static void encode(TrappedMobChestParticlesMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.chestPos);
    }

    public static TrappedMobChestParticlesMessage decode(FriendlyByteBuf buffer) {
        return new TrappedMobChestParticlesMessage(buffer.m_130135_());
    }

    public static void handle(TrappedMobChestParticlesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                TrappedMobChestParticlesMessage.spawnParticles(message.chestPos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(BlockPos pos) {
        float f2;
        float f1;
        float f;
        int col;
        Particle p;
        Vec3 offset;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        Random random = level.m_5822_();
        for (i = 0; i < 40; ++i) {
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            p = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
            if (random.nextBoolean()) {
                col = 0x686868;
                f = (float)((col & 0xFF0000) >> 16) / 255.0f;
                f1 = (float)((col & 0xFF00) >> 8) / 255.0f;
                f2 = (float)(col & 0xFF) / 255.0f;
                if (p == null) continue;
                p.m_107253_(f, f1, f2);
                continue;
            }
            col = 0xA3A3A3;
            f = (float)((col & 0xFF0000) >> 16) / 255.0f;
            f1 = (float)((col & 0xFF00) >> 8) / 255.0f;
            f2 = (float)(col & 0xFF) / 255.0f;
            if (p == null) continue;
            p.m_107253_(f, f1, f2);
        }
        for (i = 0; i < 30; ++i) {
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            p = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 20.0);
            if (random.nextBoolean()) {
                col = 0x494949;
                f = (float)((col & 0xFF0000) >> 16) / 255.0f;
                f1 = (float)((col & 0xFF00) >> 8) / 255.0f;
                f2 = (float)(col & 0xFF) / 255.0f;
                if (p == null) continue;
                p.m_107253_(f, f1, f2);
                continue;
            }
            col = 0x828282;
            f = (float)((col & 0xFF0000) >> 16) / 255.0f;
            f1 = (float)((col & 0xFF00) >> 8) / 255.0f;
            f2 = (float)(col & 0xFF) / 255.0f;
            if (p == null) continue;
            p.m_107253_(f, f1, f2);
        }
    }
}

