/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.network.message;

import iskallia.vault.world.data.TeamTaskData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UpdateAllTeamTasksMessage {
    private final Collection<TeamTaskData.TeamTasks> allTeamTasks;
    private final Map<String, String> completedTasks;

    public UpdateAllTeamTasksMessage(Collection<TeamTaskData.TeamTasks> allTeamTasks, Map<String, String> completedTasks) {
        this.allTeamTasks = allTeamTasks;
        this.completedTasks = completedTasks;
    }

    public static void encode(UpdateAllTeamTasksMessage message, FriendlyByteBuf buffer) {
        buffer.m_178352_(message.allTeamTasks, (buf, task) -> task.writeBytes((FriendlyByteBuf)buf));
        buffer.m_178355_(message.completedTasks, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_);
    }

    public static UpdateAllTeamTasksMessage decode(FriendlyByteBuf buffer) {
        return new UpdateAllTeamTasksMessage(buffer.m_178371_(ArrayList::new, TeamTaskData.TeamTasks::readBytes), buffer.m_178368_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_));
    }

    public static void handle(UpdateAllTeamTasksMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            TeamTaskData teamTaskData = TeamTaskData.get();
            teamTaskData.updateAllTeamTasks(message.allTeamTasks);
            teamTaskData.updateCompletedTasks(message.completedTasks);
        });
        context.setPacketHandled(true);
    }
}

